/*!
        @file    $Id:: test_GradientFlow.cpp #$

        @brief

        @author  Sinya Aoki <saoki@het.ph.tsukuba.ac.jp>

        @date    $LastChangedDate:: 2013-04-27 12:28:50 #$

        @version $LastChangedRevision: 875 $
*/

#include "parameterManager_YAML.h"
#include "parameters_factory.h"

#include "bridgeIO.h"
using Bridge::vout;

#include "gaugeConfig.h"

#include "action_G_Plaq.h"
#include "action_G_Rectangle.h"

#include "gradientFlow.h"

#ifdef USE_TEST
#include "test.h"
#endif

#ifdef USE_TESTMANAGER_AUTOREGISTER
#include "testManager.h"
#endif

//====================================================================
//! Test of gradientFlow.

/*!
                        [08 Jul 2012 S.Aoki]
  (Coding history will be recovered from trac.)
  YAML is implemented.  [14 Nov 2012 Y.Namekawa]
 */

namespace Test_GradientFlow {
  //- test-private parameters
  namespace {
    const std::string filename_input  = "test_GradientFlow.yaml";
    const std::string filename_output = "stdout";

    class Parameters_Test_GradientFlow : public Parameters {
     public:
      Parameters_Test_GradientFlow()
      {
        Register_string("gauge_config_type_input", "NULL");
        Register_string("config_filename_input", "NULL");

        Register_string("gauge_config_type_output", "NULL");
        Register_string("config_filename_output", "NULL");

        Register_string("verbose_level", "NULL");

        Register_double("expected_result", 0.0);
      }
    };
  }

  //- prototype declaration
  int update(void);

#ifdef USE_TESTMANAGER_AUTOREGISTER
  namespace {
    static const bool is_registered = TestManager::RegisterTest(
      "GradientFlow",
      update
      );
  }
#endif

  //====================================================================
  int update(void)
  {
    // ####  parameter setup  ####
    int Nvol = CommonParameters::Nvol();
    int Ndim = CommonParameters::Ndim();

    Parameters *params_test     = new Parameters_Test_GradientFlow;
    Parameters *params_action_G = ParametersFactory::New("Action.G_Plaq");
    Parameters *params_g_flow   = ParametersFactory::New("GradientFlow");

    Parameters *params_all = new Parameters;

    params_all->Register_Parameters("Test_GradientFlow", params_test);
    params_all->Register_Parameters("Action_G_Plaq", params_action_G);
    params_all->Register_Parameters("GradientFlow", params_g_flow);

    ParameterManager_YAML params_manager;
    params_manager.read_params(filename_input, params_all);

    const string str_gconf_read  = params_test->get_string("gauge_config_type_input");
    const string readfile        = params_test->get_string("config_filename_input");
    const string str_gconf_write = params_test->get_string("gauge_config_type_output");
    const string writefile       = params_test->get_string("config_filename_output");
    const string str_vlevel      = params_test->get_string("verbose_level");
#ifdef USE_TEST
    const double expected_result = params_test->get_double("expected_result");
#endif

    Bridge::VerboseLevel vl = vout.set_verbose_level(str_vlevel);

    //- print input parameters
    vout.general(vl, "  gconf_read  = %s\n", str_gconf_read.c_str());
    vout.general(vl, "  readfile    = %s\n", readfile.c_str());
    vout.general(vl, "  gconf_write = %s\n", str_gconf_write.c_str());
    vout.general(vl, "  writefile   = %s\n", writefile.c_str());
    vout.general(vl, "  vlevel      = %s\n", str_vlevel.c_str());
    vout.general(vl, "\n");

    //- input parameter check
    int err = 0;
    err += ParameterCheck::non_NULL(str_gconf_read);
    err += ParameterCheck::non_NULL(readfile);
    err += ParameterCheck::non_NULL(str_gconf_write);
    err += ParameterCheck::non_NULL(writefile);

    if (err) {
      vout.crucial(vl, "Test_GradientFlow: Input parameters have not been set.\n");
      abort();
    }


    // #### object setup #####
    Field_G     *U          = new Field_G(Nvol, Ndim);
    GaugeConfig *gconf_read = new GaugeConfig(str_gconf_read);
    gconf_read->read_file((Field *)U, readfile);
    // gconf->set_cold((Field*)U);

    Action_G_Plaq *action_G = new Action_G_Plaq;
    action_G->set_parameters(*params_action_G);

    GradientFlow *g_flow = new GradientFlow((Action * )action_G);
    g_flow->set_parameters(*params_g_flow);


    // ####  Execution main part  ####
    double result = g_flow->evolve(*U); // mod. by (SM)


    // ####  tydy up  ####
    delete params_test;
    delete params_action_G;
    delete params_g_flow;
    delete params_all;

    delete U;
    delete gconf_read;
    delete g_flow;
    delete action_G;


#ifdef USE_TEST
    return Test::verify(expected_result, result);

#else
    return EXIT_SUCCESS;
#endif
  }
} // namespace Test_GradientFlow
