/*!
        @file    $Id: test_IO_GaugeConfig_Text.cpp #$

        @brief

        @author  $LastChangedBy: sueda $

        @date    $LastChangedDate: 2013-03-21 15:28:34 #$

        @version $LastChangedRevision: 936 $
*/

#include "parameterManager_YAML.h"

#include "bridgeIO.h"
using Bridge::vout;

#include "gaugeConfig.h"

#include "test_IO_utils.h"

#ifdef USE_TEST
#include "test.h"
#endif

#ifdef USE_TESTMANAGER_AUTOREGISTER
#include "testManager.h"
#endif

//====================================================================
//! Test of I/O.

/*!
    (Implemented by Aoyama-san.)
    (Coding history will be recovered from trac.)
    YAML is implemented.      [14 Nov 2012 Y.Namekawa]
*/

namespace Test_IO_GaugeConfig {
  //- test-private parameters
  namespace {
    const std::string filename_input  = "test_IO_GaugeConfig_Text.yaml";
    const std::string filename_output = "stdout";

    class Parameters_Test_IO_GaugeConfig : public Parameters {
     public:
      Parameters_Test_IO_GaugeConfig()
      {
        Register_string("gauge_config_type_input", "NULL");
        Register_string("config_filename_input", "NULL");
        Register_string("config_filename_output", "NULL");

        Register_string("verbose_level", "NULL");

        Register_double("expected_result", 0.0);
      }
    };
  }

  //- prototype declaration
  int test_io_gconf_text(void);

#ifdef USE_TESTMANAGER_AUTOREGISTER
  namespace {
    static const bool is_registered = TestManager::RegisterTest(
      "IO.GaugeConfig.Text",
      test_io_gconf_text
      );
  }
#endif

  //====================================================================
  int test_io_gconf_text(void)
  {
    // ####  parameter setup  ####
    int Ndim = CommonParameters::Ndim();
    int Nvol = CommonParameters::Nvol();

    Parameters_Test_IO_GaugeConfig params_test;

    Parameters params_all;

    params_all.Register_Parameters("Test_IO_GaugeConfig", &params_test);

    ParameterManager_YAML params_manager;
    params_manager.read_params(filename_input, &params_all);

    const string str_gconf_read = params_test.get_string("gauge_config_type_input");
    const string readfile       = params_test.get_string("config_filename_input");
    const string testfile       = params_test.get_string("config_filename_output");
    const string str_vlevel     = params_test.get_string("verbose_level");
#ifdef USE_TEST
    const double expected_result = params_test.get_double("expected_result");
#endif

    Bridge::VerboseLevel vl = vout.set_verbose_level(str_vlevel);

    //- print input parameters
    vout.general(vl, "  gconf_read = %s\n", str_gconf_read.c_str());
    vout.general(vl, "  readfile   = %s\n", readfile.c_str());
    vout.general(vl, "  testfile   = %s\n", testfile.c_str());
    vout.general(vl, "  vlevel     = %s\n", str_vlevel.c_str());

    //- input parameter check
    int err = 0;
    err += ParameterCheck::non_NULL(str_gconf_read);
    err += ParameterCheck::non_NULL(readfile);
    err += ParameterCheck::non_NULL(testfile);

    if (err) {
      vout.crucial(vl, "Test_IO_GaugeConfig: Input parameters have not been set.\n");
      abort();
    }


    // ####  Set up a gauge configuration  ####
    Field_G     *U          = new Field_G(Nvol, Ndim);
    GaugeConfig *gconf_read = new GaugeConfig(str_gconf_read);
    gconf_read->read_file((Field *)U, readfile);

    Field_G     *Utest      = new Field_G(Nvol, Ndim);
    GaugeConfig *gconf_test = new GaugeConfig("Text");


    // ####  Execution main part  ####
    err = 0;

    //- first write to file.
    gconf_test->write_file(U, testfile);

    //- then read back from file.
    gconf_test->read_file(Utest, testfile);

    //- check with reference config.
    bool is_equal = (*Utest == *U);
    if (!is_equal) ++err;

    vout.general(vl, "Test_IO_GaugeConfig_Text:\t%s\n", is_equal ? "ok" : "failed");


    int result = err;


    // ####  tydy up  ####
    delete gconf_read;
    delete U;

    delete gconf_test;
    delete Utest;


#ifdef USE_TEST
    return Test::verify(expected_result, result);

#else
    return EXIT_SUCCESS;
#endif
  }
} // namespace Test_IO_GaugeConfig
