/*!
        @file    $Id: test_IO_utils.cpp #$

        @brief

        @author  $LastChangedBy: sueda $

        @date    $LastChangedDate: 2013-03-21 15:28:34 #$

        @version $LastChangedRevision: 930 $
*/

#include "commonParameters.h"
#include "bridgeIO.h"
using Bridge::vout;

#include "test_IO_utils.h"

//====================================================================
bool operator==(const Field_G& f, const Field_G& g)
{
  if (f.nin() != g.nin()) return false;

  if (f.nvol() != g.nvol()) return false;

  if (f.nex() != g.nex()) return false;

  if (f.size() != g.size()) return false;

  unsigned int size = f.size();

  Field *fp = (Field *)&f;
  Field *gp = (Field *)&g;

  for (unsigned int i = 0; i < size; ++i) {
    if (*fp->ptr(i) != *gp->ptr(i)) return false;
  }

  return true;
}


//====================================================================
namespace Test_IO_GaugeConfig {
  int check_conf(const Field_G *f, const Field_G *g)
  {
    Bridge::VerboseLevel vl = CommonParameters::Vlevel();

    int err = 0;

    int Ndim = CommonParameters::Ndim();
    int Nvol = CommonParameters::Nvol();
    int Nc   = CommonParameters::Nc();

    for (int idir = 0; idir < Ndim; ++idir) {
      for (int isite = 0; isite < Nvol; ++isite) {
        for (int i = 0; i < Nc * Nc; ++i) {
          double v1r = f->cmp_r(i, isite, idir);
          double v1i = f->cmp_i(i, isite, idir);

          double v2r = g->cmp_r(i, isite, idir);
          double v2i = g->cmp_i(i, isite, idir);

          if (!((v1r == v2r) && (v1i == v2i))) ++err;

          vout.general(vl, "%6d : %4d: %2d: %8.5f %8.5f\t%8.5f %8.5f : %s\n",
                       isite, i, idir,
                       v1r, v1i, v2r, v2i,
                       ((v1r == v2r) && (v1i == v2i)) ? "ok" : "fail");
        }
      }
    }

    vout.general(vl, "%s: error=%d\n", __func__, err);

    return err;
  }
} // namespace Test_IO_GaugeConfig
