/*!
        @file    $Id:: test_RandomNumbers_Mseries_Gaussian.cpp #$

        @brief

        @author  Hideo Matsufuru <hideo.matsufuru@kek.jp> (matsufuru)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-19 14:15:23 #$

        @version $LastChangedRevision: 936 $
*/

#include "parameterManager_YAML.h"

#include "bridgeIO.h"
using Bridge::vout;

#include "randomNumbers_Mseries.h"

#ifdef USE_TEST
#include "test.h"
#endif

#ifdef USE_TESTMANAGER_AUTOREGISTER
#include "testManager.h"
#endif

//====================================================================
//! Test of random number generator.

/*!
                                [28 Dec 2011 H.Matsufuru]
    (Coding history will be recovered from trac.)
    YAML is implemented.        [14 Nov 2012 Y.Namekawa]
 */

namespace Test_RandomNumbers {
  //- test-private parameters
  namespace {
    const std::string filename_input  = "test_RandomNumbers_Mseries_Gaussian.yaml";
    const std::string filename_output = "stdout";

    class Parameters_Test_RandomNumbers : public Parameters {
     public:
      Parameters_Test_RandomNumbers()
      {
        Register_int("seed", 0);
        Register_int("number_of_samples", 0);

        Register_string("verbose_level", "NULL");

        Register_double("expected_result", 0.0);
      }
    };
  }

  //- prototype declaration
  int gaussian(void);

#ifdef USE_TESTMANAGER_AUTOREGISTER
  namespace {
    static const bool is_registered = TestManager::RegisterTest(
      "RandomNumbers.Mseries.Gaussian",
      gaussian
      );
  }
#endif

  //====================================================================
  int gaussian(void)
  {
    // ####  parameter setup  ####
    Parameters_Test_RandomNumbers params_test;

    Parameters params_all;

    params_all.Register_Parameters("Test_RandomNumbers", &params_test);

    ParameterManager_YAML params_manager;
    params_manager.read_params(filename_input, &params_all);

    int          iseed      = params_test.get_int("seed");
    int          Nrand      = params_test.get_int("number_of_samples");
    const string str_vlevel = params_test.get_string("verbose_level");
#ifdef USE_TEST
    const double expected_result = params_test.get_double("expected_result");
#endif

    Bridge::VerboseLevel vl = vout.set_verbose_level(str_vlevel);

    //- print input parameters
    vout.general(vl, "  iseed  = %d\n", iseed);
    vout.general(vl, "  Nrand  = %d\n", Nrand);
    vout.general(vl, "  vlevel = %s\n", str_vlevel.c_str());
    vout.general(vl, "\n");


    // ####  object setup  ####
    RandomNumbers *rand = new RandomNumbers_Mseries(iseed);


    // ####  Execution main part  ####
    double av = 0.0;
    double vr = 0.0;

    double rn1, rn2;
    for (int i = 0; i < Nrand; ++i) {
      rand->gauss(rn1, rn2);
      av += rn1 + rn2;
      vr += rn1 * rn1 + rn2 * rn2;
      // vout.general(vl, "  %10.8f  %10.8f\n",rn1,rn2);
    }
    av = av / (2.0 * Nrand);
    vr = vr / (2.0 * Nrand) - av * av;
    vr = sqrt(vr);

    vout.general(vl, "\n");
    vout.general(vl, "Gaussian distribution:\n");
    vout.general(vl, "  number of samples = %10d\n", Nrand);
    vout.general(vl, "  average           = %10.8f\n", av);
    vout.general(vl, "  variance          = %10.8f\n", vr);
    vout.general(vl, "  variance(expect)  = %10.8f\n", 1.0 / sqrt(2.0));

    double result = vr;


    // ####  tidy up  ####
    delete rand;


#ifdef USE_TEST
    return Test::verify(expected_result, result);

#else
    return EXIT_SUCCESS;
#endif
  }
} // namespace Test_RandomNumbers
