/*!
        @file    $Id:: test_RandomNumbers_Mseries_GaussianField.cpp #$

        @brief

        @author  Hideo Matsufuru <hideo.matsufuru@kek.jp> (matsufuru)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/

#include "parameterManager_YAML.h"

#include "bridgeIO.h"
using Bridge::vout;

#include "randomNumbers_Mseries.h"

#ifdef USE_TEST
#include "test.h"
#endif

#ifdef USE_TESTMANAGER_AUTOREGISTER
#include "testManager.h"
#endif

//====================================================================
//! Test of random number generator.

/*!
                                [28 Dec 2011 H.Matsufuru]
    (Coding history will be recovered from trac.)
    YAML is implemented.        [14 Nov 2012 Y.Namekawa]
 */

namespace Test_RandomNumbers {
  //- test-private parameters
  namespace {
    const std::string filename_input  = "test_RandomNumbers_Mseries_GaussianField.yaml";
    const std::string filename_output = "stdout";

    class Parameters_Test_RandomNumbers : public Parameters {
     public:
      Parameters_Test_RandomNumbers()
      {
        Register_int("seed", 0);

        Register_string("verbose_level", "NULL");

        Register_double("expected_result", 0.0);
      }
    };
  }

  //- prototype declaration
  int gaussian_field(void);

#ifdef USE_TESTMANAGER_AUTOREGISTER
  namespace {
    static const bool is_registered = TestManager::RegisterTest(
      "RandomNumbers.Mseries.GaussianField",
      gaussian_field
      );
  }
#endif

  //====================================================================
  int gaussian_field(void)
  {
    // ####  parameter setup  ####
    Parameters_Test_RandomNumbers params_test;

    Parameters params_all;

    params_all.Register_Parameters("Test_RandomNumbers", &params_test);

    ParameterManager_YAML params_manager;
    params_manager.read_params(filename_input, &params_all);

    int          iseed      = params_test.get_int("seed");
    const string str_vlevel = params_test.get_string("verbose_level");
#ifdef USE_TEST
    const double expected_result = params_test.get_double("expected_result");
#endif

    Bridge::VerboseLevel vl = vout.set_verbose_level(str_vlevel);

    //- print input parameters
    vout.general(vl, "  iseed  = %d\n", iseed);
    vout.general(vl, "  vlevel = %s\n", str_vlevel.c_str());
    vout.general(vl, "\n");


    // ####  object setup  ####
    RandomNumbers *rand = new RandomNumbers_Mseries(iseed);


    // ####  Execution main part  ####
    int   Nin  = 29;
    int   Nvol = CommonParameters::Nvol();
    int   Nex  = 33;
    Field v(Nin, Nvol, Nex);

    double av = 0.0;
    double vr = 0.0;

    rand->gauss_lex_global(v);

    int size = v.size();
    for (int i = 0; i < size; ++i) {
      av += v.cmp(i);
      vr += v.cmp(i) * v.cmp(i);
      // vout.general(vl, "  %10.8f\n",v.cmp(i));
    }
    av = av / size;
    vr = vr / size - av * av;
    vr = sqrt(vr);

    vout.general(vl, "\n");
    vout.general(vl, "Gaussian distribution (Field):\n");
    vout.general(vl, "  number of samples = %10d\n", size);
    vout.general(vl, "  average           = %10.8f\n", av);
    vout.general(vl, "  variance          = %10.8f\n", vr);
    vout.general(vl, "  variance(expect)  = %10.8f\n", 1.0 / sqrt(2.0));

    double result = vr;


    // ####  tidy up  ####
    delete rand;


#ifdef USE_TEST
    return Test::verify(expected_result, result);

#else
    return EXIT_SUCCESS;
#endif
  }
} // namespace Test_RandomNumbers
