/*!
        @file    $Id:: director.h #$

        @brief

        @author  <Hideo Matsufuru> hideo.matsufuru@kek.jp(matsufuru)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/


#ifndef DIRECTOR_INCLUDED
#define DIRECTOR_INCLUDED

#include "defs.h"
#include "commonParameters.h"
#include "bridgeIO.h"

//! Manager of commonly used data object in HMC.

/*!
    Director-type class manages data which requires memory cost
    and/or computational cost to be held in multiple objects.
    Examples are smeared configurations and eigenvectors.
    This mechanism is useful mainly in HMC, while also in
    defining such as smeared fermion operators.
                                    [28 Dec 2011 H.Matsufuru]
 */

class Director
{
 protected:
  Bridge::VerboseLevel m_vl;

 public:
  Director()
    : m_vl(CommonParameters::Vlevel()) {}
  virtual ~Director() {}

  // To be called when link variable is updated.
  virtual void notify_linkv() = 0;

  void set_parameter_verboselevel(const Bridge::VerboseLevel vl) { m_vl = vl; }
};
#endif
