/*!
        @file    $Id:: director_Smear.cpp #$

        @brief

        @author  <Hideo Matsufuru> hideo.matsufuru@kek.jp(matsufuru)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/

#include "director_Smear.h"

#ifdef USE_PARAMETERS_FACTORY
#include "parameters_factory.h"
#endif

//- parameter entries
namespace {
  void append_entry(Parameters& param)
  {
    param.Register_int("number_of_smearing", 0);

    param.Register_string("verbose_level", "NULL");
  }


#ifdef USE_PARAMETERS_FACTORY
  bool init_param = ParametersFactory::Register("Director_Smear", append_entry);
#endif
}
//- end

//- parameters class
Parameters_Director_Smear::Parameters_Director_Smear() { append_entry(*this); }
//- end

//====================================================================
void Director_Smear::set_parameters(const Parameters& params)
{
  const string str_vlevel = params.get_string("verbose_level");

  m_vl = vout.set_verbose_level(str_vlevel);

  //- fetch and check input parameters
  int Nsmear;

  int err = 0;
  err += params.fetch_int("number_of_smearing", Nsmear);

  if (err) {
    vout.crucial(m_vl, "Director_Smear: fetch error, input parameter not found.\n");
    abort();
  }


  set_parameters(Nsmear);
}


//====================================================================
void Director_Smear::set_parameters(int Nsmear)
{
  int Nvol = CommonParameters::Nvol();
  int Ndim = CommonParameters::Ndim();

  //- print input parameters
  vout.general(m_vl, "Parameters of Director_Smear:\n");
  vout.general(m_vl, "  Nsmear = %d\n", Nsmear);

  //- range check
  // NB. Nsmear == 0 is allowed.

  //- store values
  m_Nsmear = Nsmear;

  //- post-process
  m_Usmear.resize(m_Nsmear);
  if (m_Nsmear > 0) {
    for (int i_smear = 0; i_smear < m_Nsmear; ++i_smear) {
      m_Usmear[i_smear].reset(Nvol, Ndim);
    }
    vout.detailed(m_vl, " size of Usmear[i_smear] was set.\n");
  }
}


//====================================================================
void Director_Smear::set_config(Field *U)
{
  m_U = (Field_G *)U;

  if (m_status_linkv == 0) smear();
}


//====================================================================
Field *Director_Smear::getptr_smearedConfig(int i_smear)
{
  assert(m_U != 0);

  if (i_smear == 0) {
    return m_U;
  } else {
    return &m_Usmear[i_smear - 1];
  }
}


//====================================================================
void Director_Smear::smear()
{
  if (m_Nsmear > 0) {
    int Nvol = m_U->nvol();
    int Nex  = m_U->nex();

    Field_G Usmear(Nvol, Nex);
    Field_G Uprev(Nvol, Nex);

    for (int i_smear = 0; i_smear < m_Nsmear; ++i_smear) {
      if (i_smear == 0) {
        Uprev = *m_U;
      } else {
        Uprev = m_Usmear[i_smear - 1];
      }
      m_smear->smear(Usmear, Uprev);
      m_Usmear[i_smear] = (Field)Usmear;
    }
  }

  ++m_status_linkv;
}


//====================================================================
//============================================================END=====
