/*!
        @file    $Id:: director_Smear.h #$

        @brief

        @author  <Hideo Matsufuru> hideo.matsufuru@kek.jp(matsufuru)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/


#ifndef DIRECTOR_SMEAR_INCLUDED
#define DIRECTOR_SMEAR_INCLUDED

#include <cassert>

#include "director.h"
#include "smear.h"
#include "parameters.h"
#include "communicator.h"
#include "field_G.h"

#include "bridgeIO.h"
using Bridge::vout;

//- parameters class
//! Parameters class for Director_Smear class.
class Parameters_Director_Smear : virtual public Parameters
{
 public:
  Parameters_Director_Smear();
};
//- end

//! Manager of smeared configurations.

/*!
    This director class handles smeared configurations.
                            [28 Dec 2011 H.Matsufuru]
    (Coding history will be recovered from trac.)
    YAML is implemented.    [14 Nov 2012 Y.Namekawa]
 */

class Director_Smear : public Director
{
 private:
  int                    m_Nsmear;       //!< number of smearing to be applied
  Smear                  *m_smear;       //!< smearing operator
  Field_G                *m_U;           //!< original thin link var.
  std::valarray<Field_G> m_Usmear;       //!< smeared configs.
  int                    m_status_linkv; //!< set to zero when link var. is updated

 public:

  //! constructor requires pointer to Smear object
  Director_Smear(Smear *smear)
    : Director()
  {
    m_Nsmear       = 0;
    m_smear        = smear;
    m_U            = 0;
    m_status_linkv = 0;
  }

  //! set paramters, must be called before set_config
  void set_parameters(const Parameters& params);
  void set_parameters(int Nsmear);

  //! get number of applied smearing operation
  int get_Nsmear() { return m_Nsmear; }

  //! get pointer to i-th smeared config (0th is original thin link)
  Field *getptr_smearedConfig(int i_smear);

  //! set pointer to original thin link variable
  void set_config(Field *U);

  //! to be called when configuration is updated
  void notify_linkv()
  {
    m_status_linkv = 0;
  }

 private:
  //! smearing is performed by calling a function of Smear object
  void smear();
};
#endif
