/*!
        @file    $Id:: file_utils.cpp #$

        @brief

        @author  Tatsumi Aoyama <aoym@post.kek.jp> (aoym)
                 $LastChangedBy: aoym $

        @date    $LastChangedDate:: 2013-01-22 13:51:53 #$

        @version $LastChangedRevision: 834 $
*/

#include "file_utils.h"

//====================================================================
string FileUtils::generate_filename(const string& base, const int idx)
{
  char buf[1024];

  sprintf(buf, "%s_%02d.dat", base.c_str(), idx);

  return string(buf);
}


//====================================================================
string FileUtils::generate_filename(const string& base, const int icolor, const int ispin)
{
  char buf[1024];

  sprintf(buf, "%s_c%d_s%d.dat", base.c_str(), (icolor + 1), (ispin + 1));

  return string(buf);
}


//==========================================================
//==================================================END=====
