/*!
        @file    $Id:: math_Rational.h #$

        @brief

        @author  <Hideo Matsufuru> hideo.matsufuru@kek.jp(matsufuru)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/

#ifndef MATH_RATIONAL_INCLUDED
#define MATH_RATIONAL_INCLUDED

#include <fstream>
#include <cmath>
#include <cassert>

#include "parameters.h"
#include "commonParameters.h"

#include "bridgeIO.h"
using Bridge::vout;

//! Determionation of coefficients of rational approximation.

/*!
    At present, the coefficients are determined outside this
    code system and save to a file.
    At present, this class just read these data from a file
    to set the coefficients, as temporary implementation.
    In future, self-calculation should be implemented.
                                    [28 Dec 2011 H.Matsufuru]
    (Coding history will be recovered from trac.)
    YAML is implemented.         [14 Nov 2012 Y.Namekawa]
 */

//- parameters class
class Parameters_Math_Rational : virtual public Parameters
{
 public:
  Parameters_Math_Rational();
};
//- end

class Math_Rational
{
 protected:
  Bridge::VerboseLevel m_vl;

 private:
  int                   m_Np, m_n_exp, m_d_exp;
  double                m_x_min, m_x_max;
  double                m_norm, m_error;
  std::valarray<double> m_res;
  std::valarray<double> m_pole;

 public:
  Math_Rational()
    : m_vl(CommonParameters::Vlevel()) {}

  void set_parameters(const Parameters& params);
  void set_parameters(const int Np, const int n_exp, const int d_exp,
                      const double x_min, const double x_max);

  void get_parameters(double& norm, std::valarray<double>& res,
                      std::valarray<double>& pole);

  void set_parameter_verboselevel(const Bridge::VerboseLevel vl) { m_vl = vl; }

  double func(double x);

 private:
  void set_coeff();
  void read_file();
};
#endif
