/*!
        @file    $Id:: randomNumbers.h #$

        @brief

        @author  <Hideo Matsufuru> hideo.matsufuru@kek.jp(matsufuru)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/


#ifndef RANDOMNUMBERS_INCLUDED
#define RANDOMNUMBERS_INCLUDED

#include <cmath>
#include <string>

#include "defs.h"
#include "commonParameters.h"
#include "bridgeIO.h"
#include "field.h"

//! Base class of random number generators.

/*!
   This class defines the interface of random number
   generator, and implements common methds.
   Practical methods to generate random numbers are
   defined in subclasses.
   This class also implements Gaussian random number and
   method to set a global field of Gaussian random numbers
   and cut it out to the local field for the own node
   (gauss_lex_global()) which is useful in HMC etc.
                                 [25 Dec 2011 H.Matsufuru]
 */

class RandomNumbers
{
 protected:
  Bridge::VerboseLevel m_vl;

 public:

  RandomNumbers()
    : m_vl(CommonParameters::Vlevel()) {}

  virtual ~RandomNumbers() {}

  void set_parameter_verboselevel(const Bridge::VerboseLevel vl) { m_vl = vl; }

  virtual double get() = 0;

  void gauss(double& rn1, double& rn2);

  void uniform(Field&);
  void gauss(Field&);

  //! gaussian random number defined on global lattice.
  void gauss_lex_global(Field&);

  //! gaussian noise for even-odd perconditioned field (S.UEDA)
  void gauss_eo_global(Field&);

  //! uniform random number defined on global lattice.
  void uniform_lex_global(Field&);
};
#endif
