/*!
        @file    $Id:: randomNumbers_Mseries.h #$

        @brief

        @author  <Hideo Matsufuru> hideo.matsufuru@kek.jp(matsufuru)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/

#ifndef RANDOMNUMBERS_MSERIES_INCLUDED
#define RANDOMNUMBERS_MSERIES_INCLUDED

#include <assert.h>
#include <cmath>
#include <fstream>
#include <iostream>
#include <string>

#include "randomNumbers.h"
#include "communicator.h"

#include "bridgeIO.h"
using Bridge::vout;

//! Random number generator base on M-series.

/*!
    This class generates the M-series random numbers.
    The original version in Fortran was written by
             J.Makino and O.Miyamura (Ver.3.0 21 July 1991).
    Public version is available under GNU GPL:
     Shinji Hioki, QCDMPI http://insam.sci.hiroshima-u.ac.jp/QCDMPI/
    which implements
     Jun Makino, "Lagged-Fibonacci random number generators on parallel
     computers", Parallel Computing, 20 (1994) 1357-1367.

    An instance is created with a given integer number which is used
    to set the initial random numbers.
                                          [23 Jul 2012 H.Matsufuru]
 */

class RandomNumbers_Mseries : public RandomNumbers
{
 protected:
  Bridge::VerboseLevel m_vl;

 private:
  static const int Np = 521, Nq = 32;
  double           Fnorm;
  int              w[Np];
  int              jr, kr;

  double sq2r;
  double pi, pi2;

 public:
  RandomNumbers_Mseries(const int ndelay)
  {
    Fnorm = 4.656612870908988e-10;
    initset(ndelay);
  }

  RandomNumbers_Mseries(const std::string filename)
  {
    Fnorm = 4.656612870908988e-10;
    set_readfile(filename);
  }

  double get()
  {
    w[jr] = w[jr] ^ w[kr];
    double rw = w[jr] * Fnorm;
    jr = jr + 1;
    if (jr >= Np) jr = jr - Np;
    kr = kr + 1;
    if (kr >= Np) kr = kr - Np;
    return rw;
  }

  void writefile(const std::string);

 private:
  void set_readfile(const std::string);

  void initset(const int ndelay);

  void delay3(const int ndelay);
};
#endif
