/*!
        @file    $Id:: timer.h #$

        @brief

        @author  Tatsumi Aoyama <aoym@post.kek.jp> (aoym)
                 $LastChangedBy: sueda $

        @date    $LastChangedDate:: 2013-07-12 16:56:41 #$

        @version $LastChangedRevision: 930 $
*/

#ifndef TIMER_INCLUDED
#define TIMER_INCLUDED

//#define USE_RUSAGE
#undef USE_RUSAGE

#ifdef USE_RUSAGE
#include <sys/resource.h>
#endif

#include <cstdio>
#include <time.h>
#include <sys/time.h>

#include "bridgeIO.h"
using Bridge::vout;


class Timer {
 public:
  Timer() : is_started(false), m_start(0), m_elapsed(0), m_counter(0) {}
  ~Timer() {}

  void start();
  void stop();
  void reset();

  void timestamp();

  double elapsed_msec() const;
  unsigned long get_counter() const;

 private:
  bool   is_started;
  double m_start;

  double        m_elapsed; // sec.
  unsigned long m_counter;
};
#endif /* _TIMER_H_ */
