#ifndef SFMT_JUMP_ALT_INCLUDED
#define SFMT_JUMP_ALT_INCLUDED

#include "sfmt-config.h"

#ifdef HAVE_NTL

#include <NTL/GF2X.h>

typedef struct {
  NTL::GF2X jump_poly;
  long step;
} sfmt_jump_t;


void sfmt_jump(sfmt_t * sfmt, const long step, const NTL::GF2X& characterisitc_polynomial);

void sfmt_calculate_jump_polynomial(sfmt_jump_t& jump, const long step, const NTL::GF2X& characterisitc_polynomial);

void sfmt_jump_by_polynomial(sfmt_t * sfmt, const sfmt_jump_t& jump);

NTL::GF2X sfmt_characteristic_polynomial();

#endif

#endif /* SFMT_JUMP_ALT_INCLUDED */
