/*!
        @file    bridge.h

        @brief   compilation of Bridge++ header files

        @author  $LastChangedBy: kanamori $

        @date    $LastChangedDate:: 2026-01-06 12:50:58 #$

        @version $LastChangedRevision: 2681 $
*/

//----------------------------------------------------------------
// "import-everything" header file
//----------------------------------------------------------------

#ifndef BRIDGE_INCLUDED
#define BRIDGE_INCLUDED

#include "configure.h"
#include "bridge_defs.h"
#include "bridge_complex.h"
#include "bridge_long.h"
#include "bridge_setup.h"
#include "bridge_init_factory.h"
#include "Action/Fermion/action_F_Ratio_eo.h"
#include "Action/Fermion/action_F_Ratio_lex.h"
#include "Action/Fermion/action_F_Rational.h"
#include "Action/Fermion/action_F_Rational_SF.h"
#include "Action/Fermion/action_F_Staggered_eo.h"
#include "Action/Fermion/action_F_Standard_SF.h"
#include "Action/Fermion/action_F_Standard_eo.h"
#include "Action/Fermion/action_F_Standard_lex.h"
#include "Action/Gauge/action_G_Plaq.h"
#include "Action/Gauge/action_G_Plaq_SF.h"
#include "Action/Gauge/action_G_Rectangle.h"
#include "Action/Gauge/action_G_Rectangle_SF.h"
#include "Action/action.h"
#include "Communicator/communicator.h"
#include "Eigen/eigensolver.h"
#include "Eigen/eigensolver_IRLanczos.h"
#include "Field/field.h"
#include "Field/field_F.h"
#include "Field/field_F_1spinor.h"
#include "Field/field_G.h"
#include "Field/field_SF.h"
#include "Field/index_eo.h"
#include "Field/index_lex.h"
#include "Field/shiftField_eo.h"
#include "Field/shiftField_lex.h"
#include "Fopr/fopr.h"
#include "Fopr/fopr_CRS.h"
#include "Fopr/fopr_Chebyshev.h"
#include "Fopr/fopr_Clover.h"
#include "Fopr/fopr_CloverGeneral.h"
#include "Fopr/fopr_CloverTerm.h"
#include "Fopr/fopr_CloverTerm_General.h"
#include "Fopr/fopr_CloverTerm_eo.h"
#include "Fopr/fopr_Clover_Chemical.h"
#include "Fopr/fopr_Clover_SF.h"
#include "Fopr/fopr_Clover_eo.h"
#include "Fopr/fopr_Domainwall.h"
#include "Fopr/fopr_Overlap.h"
#include "Fopr/fopr_Rational.h"
#include "Fopr/fopr_Rational_SF.h"
#include "Fopr/fopr_Sign.h"
#include "Fopr/fopr_Smeared.h"
#include "Fopr/fopr_Smeared_eo.h"
#include "Fopr/fopr_Staggered_eo.h"
#include "Fopr/fopr_Wilson_TwistedMass.h"
#include "Fopr/fopr_Wilson.h"
#include "Fopr/fopr_WilsonGeneral.h"
#include "Fopr/fopr_Wilson_Chemical.h"
#include "Fopr/fopr_Wilson_SF.h"
#include "Fopr/fopr_Wilson_eo.h"
#include "Fopr/fopr_eo.h"
#include "Force/Fermion/force_F.h"
#include "Force/Fermion/force_F_CloverTerm.h"
#include "Force/Fermion/force_F_Clover_Nf2.h"
#include "Force/Fermion/force_F_Clover_Nf2_Isochemical.h"
#include "Force/Fermion/force_F_Clover_SF.h"
#include "Force/Fermion/force_F_Domainwall.h"
#include "Force/Fermion/force_F_Rational.h"
#include "Force/Fermion/force_F_Smeared.h"
#include "Force/Fermion/force_F_Staggered_eo.h"
#include "Force/Fermion/force_F_Wilson_TwistedMass_Nf2.h"
#include "Force/Fermion/force_F_Wilson_Nf2.h"
#include "Force/Fermion/force_F_Wilson_Nf2_Isochemical.h"
#include "Force/Fermion/force_F_Wilson_SF.h"
#include "Force/Fermion/force_F_Wilson_eo.h"
#include "Force/Fermion/tensorProd.h"
#include "Force/Gauge/force_G.h"
#include "Force/Gauge/force_G_Plaq.h"
#include "Force/Gauge/force_G_Plaq_SF.h"
#include "Force/Gauge/force_G_Rectangle.h"
#include "Force/Gauge/force_G_Rectangle_SF.h"
#include "HMC/action_list.h"
#include "HMC/builder_Integrator.h"
#include "HMC/hmc_General.h"
#include "HMC/hmc_Leapfrog.h"
#include "HMC/integrator.h"
#include "HMC/integrator_Leapfrog.h"
#include "HMC/integrator_Omelyan.h"
#include "HMC/integrator_UpdateP.h"
#include "HMC/integrator_UpdateU.h"
#include "HMC/langevin_Momentum.h"
#include "IO/bridgeIO.h"
#include "IO/dataIO.h"
#include "IO/dataIO_Text.h"
#include "IO/dataIO_Text_impl.h"
#include "IO/fieldIO.h"
#include "IO/fieldIO_Binary.h"
#include "IO/fieldIO_Binary_Distributed.h"
#include "IO/fieldIO_Binary_Parallel.h"
#include "IO/fieldIO_Fortran.h"
#include "IO/fieldIO_LIME.h"
#include "IO/fieldIO_LIME_Parallel.h"
#include "IO/fieldIO_None.h"
#include "IO/fieldIO_Text.h"
#include "IO/fieldIO_Text_4x4x4x8.h"
#include "IO/gaugeConfig.h"
#include "IO/gaugeConfig_SF.h"
#include "IO/io_format.h"
#include "IO/io_format_gauge.h"
#include "Measurements/Fermion/contract_4spinor.h"
#include "Measurements/Fermion/corr2pt_4spinor.h"
#include "Measurements/Fermion/corr2pt_Staggered.h"
#include "Measurements/Fermion/corr2pt_Wilson_SF.h"
#include "Measurements/Fermion/corr4pt_4spinor.h"
#include "Measurements/Fermion/fprop.h"
#include "Measurements/Fermion/fprop_Standard_eo.h"
#include "Measurements/Fermion/fprop_Standard_lex.h"
#include "Measurements/Fermion/fprop_Wilson_Shift.h"
#include "Measurements/Fermion/noiseVector.h"
#include "Measurements/Fermion/noiseVector_Z2.h"
#include "Measurements/Fermion/quarkNumberSusceptibility_Wilson.h"
#include "Measurements/Fermion/source.h"
#include "Measurements/Fermion/source_Exponential.h"
#include "Measurements/Fermion/source_Local.h"
#include "Measurements/Fermion/source_MomentumWall.h"
#include "Measurements/Fermion/source_Random.h"
#include "Measurements/Fermion/source_Staggered_Wall.h"
#include "Measurements/Fermion/source_Wall.h"
#include "Measurements/Fermion/source_Wall_SF.h"
#include "Measurements/Gauge/energyDensity.h"
#include "Measurements/Gauge/energyMomentumTensor.h"
#include "Measurements/Gauge/fieldStrength.h"
#include "Measurements/Gauge/gaugeFixing.h"
#include "Measurements/Gauge/gaugeFixing_Coulomb.h"
#include "Measurements/Gauge/gaugeFixing_Landau.h"
#include "Measurements/Gauge/gaugeFixing_None.h"
#include "Measurements/Gauge/gradientFlow.h"
#include "Measurements/Gauge/gradientFlow_AdaptiveRungeKutta.h"
#include "Measurements/Gauge/gradientFlow_RungeKutta.h"
#include "Measurements/Gauge/gradientFlow_RungeKutta_1st.h"
#include "Measurements/Gauge/gradientFlow_RungeKutta_2nd.h"
#include "Measurements/Gauge/gradientFlow_RungeKutta_3rd.h"
#include "Measurements/Gauge/gradientFlow_RungeKutta_4th.h"
#include "Measurements/Gauge/polyakovLoop.h"
#include "Measurements/Gauge/staple.h"
#include "Measurements/Gauge/staple_SF.h"
#include "Measurements/Gauge/staple_eo.h"
#include "Measurements/Gauge/staple_lex.h"
#include "Measurements/Gauge/topologicalCharge.h"
#include "Measurements/Gauge/wilsonLoop.h"
#include "Parameters/commonParameters.h"
#include "Parameters/parameterCheck.h"
#include "Parameters/parameterManager.h"
#include "Parameters/parameterManager_XML.h"
#include "Parameters/parameterManager_YAML.h"
#include "Parameters/parameters.h"
#include "ResourceManager/threadManager.h"
#include "Smear/director_Smear.h"
#include "Smear/projection.h"
#include "Smear/projection_Maximum_SU_N.h"
#include "Smear/projection_Stout_SU3.h"
#include "Smear/smear.h"
#include "Smear/smear_APE.h"
#include "Smear/smear_APE_SF.h"
#include "Smear/smear_APE_spatial.h"
#include "Smear/smear_HYP.h"
#include "Smear/smear_HYP_SF.h"
#include "Solver/shiftsolver.h"
#include "Solver/shiftsolver_CG.h"
#include "Solver/solver.h"
#include "Solver/solver_BiCGStab_Cmplx.h"
#include "Solver/solver_BiCGStab_DS_L_Cmplx.h"
#include "Solver/solver_BiCGStab_IDS_L_Cmplx.h"
#include "Solver/solver_BiCGStab_L_Cmplx.h"
#include "Solver/solver_CG.h"
#include "Solver/solver_CGNE.h"
#include "Solver/solver_CGNR.h"
#include "Solver/solver_GMRES_m_Cmplx.h"
#include "Tools/decompose_Hessenberg_Cmplx.h"
#include "Tools/decompose_LUP_Cmplx.h"
#include "Tools/decompose_LU_Cmplx.h"
#include "Tools/decompose_QR_Cmplx.h"
#include "Tools/director.h"
#include "Tools/eigen_QR_Cmplx.h"
#include "Tools/epsilonTensor.h"
#include "Tools/evalexpr.h"
#include "Tools/fft.h"
#include "Tools/fft_3d.h"
#include "Tools/fft_3d_local.h"
#include "Tools/fft_3d_parallel1d.h"
#include "Tools/fft_3d_parallel3d.h"
#include "Tools/fft_xyz_1dim.h"
#include "Tools/fft_xyz_3dim.h"
#include "Tools/file_utils.h"
#include "Tools/filename.h"
#include "Tools/gammaMatrix.h"
#include "Tools/gammaMatrixSet.h"
#include "Tools/gammaMatrixSet_Chiral.h"
#include "Tools/gammaMatrixSet_Dirac.h"
#include "Tools/generatorSet_Mat_SU_N.h"
#include "Tools/mat_SU_N.h"
#include "Tools/math_Rational.h"
#include "Tools/math_Sign_Zolotarev.h"
#include "Tools/randomNumberManager.h"
#include "Tools/randomNumbers.h"
#include "Tools/randomNumbers_MT19937.h"
#include "Tools/randomNumbers_Mseries.h"
#include "Tools/randomNumbers_SFMT.h"
#include "Tools/sorter.h"
#include "Tools/timer.h"
#include "Tools/vec_SU_N.h"

#endif /* BRIDGE_INCLUDED */
