/*!
        @file    doxygen.h

        @brief

        @author  Shinji Motoki  (smotoki)
                 $LastChangedBy: matufuru $

        @date    $LastChangedDate:: 2025-12-10 19:07:14 #$

        @version $LastChangedRevision: 2673 $
*/

#ifndef DOXYGEN_INCLUDED
#define DOXYGEN_INCLUDED

/**
   \mainpage Lattice QCD common code development Project
   \section intro [Introduction]
    Bridge++ is a code set for performing calculations in lattice QCD on linux workstations, and  \n
    supercomputers using "C/C++" standard language with MPI.
    \n

   \section environment [Environment]
        - Target platforms are listed in Makefile.
        - For confirmation on each environment, see Bridge++ wiki.
          https://www.bridge-hpc.org/
        \n
   \section install [Install]
        - See INSTALL.txt in the code set.
    \n

   \section author [Authors]
   \subsection project_member Project Member
   Tatsumi   Aoyama    (Univ. Tokyo)      \n
   Issaku    Kanamori  (RIKEN R-CCS)      \n
   Kazuyuki  Kanaya    (Univ. of Tsukuba) \n
   Hideo     Matsufuru (KEK)              \n
   Yusuke    Namekawa  (Hiroshima Univ.)  \n
   Hidekatsu Nemura    (Kyoto Univ.)      \n
   Keigo     Nitadori  (RIKEN R-CCS)      \n

   \subsection contributer Contributer
   Shinya    Aoki      (Kyoto Univ.)      \n
   Wei-Lun   Chen      (SOKENDAI)         \n
   Takumi    Doi       (RIKEN)            \n
   Shoji     Hashimoto (KEK)              \n
   Noriyoshi Ishii     (Osaka Univ.)      \n
   Ken-ichi  Ishikawa  (Hiroshima Univ.)  \n
   Takashi   Kaneko    (KEK)              \n
   Yoshinobu Kuramashi (Univ. of Tsukuba) \n
   Kenji     Sasaki    (Osaka Univ.)      \n
   Naoya     Ukita     (Univ. of Tsukuba) \n
   Tomoteru  Yoshie    (Univ. of Tsukuba) \n

   \subsection former_member Former Member
   Yutaro    Akahoshi \n
   Guido     Cossu    \n
   Takaya    Miyamoto \n
   Shinji    Motoki   \n
   Jun-Ichi  Noaki    \n
   Kenji     Ogawa    \n
   Hana      Saito    \n
   Yusuke    Taniguchi\n
   Satoru    Ueda     \n

   \section history [History]
    - 2023/03/01    Version 2.0 Release.
    - 2021/03/30    Version 1.6 Release.
    - 2019/03/07    Version 1.5 Release.
    - 2017/03/15    Version 1.4 Release.
    - 2015/10/08    Version 1.3 Release.
    - 2014/09/17    Version 1.2 Release.
    - 2013/07/22    Version 1.1 Release.
    - 2012/07/25    Version 1.0 Release.
    - 2009/10/15    Bridge++ Project started.
 */
#endif // DOXYGEN_INCLUDED


//   \section reference Reference
//    - [ref]
//    - [ref]
